function cycle = importCycle(dataFile)
    arguments
        dataFile string = []; 
    end

    if isempty(dataFile)
        [dataFile, path] = uigetfile({'*.xlsx;*.xls',...
            'Excel Spreadsheet (*.xlsx,*.xls)';
            '*.*',  'All Files (*.*)'}, ...
            'Select a File');
        dataFile = fullfile(path, dataFile);
    end
    
    %% 
    opts = detectImportOptions(dataFile);
    opts.VariableUnitsRange = 'A2:C2';
    cycleData = readtable(dataFile, opts);
    cycle.time_s = cycleData.time;
    switch cycleData.Properties.VariableUnits(2)
        case 'km/h'
            cycle.speed_kmh = cycleData.speed;
        case 'm/s'
            cycle.speed_kmh = cycleData.speed ./ 3.6;
        otherwise
            error("Unit?")
    end
    cycle.grad_percent = cycleData.gradient;

end